/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_07; import djbuch.kapitel_06.GC;
import lotus.domino.*;

/**
 * @author Thomas Ekert
 */
public class ShowURLMethods extends NotesThread {

	private static final String PASSWORD = "geheim";
	private static final String HOST = null;//"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null;//"Thomas Ekert/DJBUCH";	//null fr lokale Session

	public static void main(String[] args) {
		ShowURLMethods sum = new ShowURLMethods();
		sum.start();
	}
	public void runNotes() {
		Document doc = null;
		Database db = null;
		View view = null;
		Agent agent = null;
		Form form = null;
		RichTextItem rt = null;
		Session session = null;
		DbDirectory dbdir = null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase(session.getServerName(), "djbuch/djbuch.nsf");
			doc = db.createDocument();
			doc.replaceItemValue("Form","FO_Dokument_k2");
			doc.save();
			agent = db.getAgent(" AG_WebAgentXML");
			form = db.getForm ("FO_Dokument_k2");
			view = db.getView ("V_Dokumente_k2");
			printURLs (db);
			printURLs (doc);
			printURLs (form);
			printURLs (view);
			printURLs (agent);
			printURLs (session);
			System.out.println ("\nWichtiger Hinweis: Beachten Sie die unterschiedlichen Ausgaben fr Lokale und DIIOP Sessions.");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			GC.recycle (rt);
			GC.recycle (doc);
			GC.recycle (view);
			GC.recycle (form);
			GC.recycle (agent);
			GC.recycle (db);
			GC.recycle (session);
		}
		
	}
	private static String name (Object o) {
		String n = o.getClass().getName();
		return n.substring(n.lastIndexOf(".")+1,n.length());
		
	}
	private static void printURLs (Document o) throws NotesException {
		System.out.println ("getURL\t\tvon " + name (o) + ": " + o.getURL());
		System.out.println ("getNotesURL\tvon " + name(o) + ": " + o.getNotesURL());
		System.out.println ("getHttpURL\tvon " + name(o) + ": " + o.getHttpURL());
	}

	private static void printURLs (Agent o) throws NotesException {
		System.out.println ("getURL\t\tvon " + name (o) + ": " + o.getURL());
		System.out.println ("getNotesURL\tvon " + name(o) + ": " + o.getNotesURL());
		System.out.println ("getHttpURL\tvon " + name(o) + ": " + o.getHttpURL());
	}
	private static void printURLs (Database o) throws NotesException {
		System.out.println ("getURL\t\tvon " + name (o) + ": " + o.getURL());
		System.out.println ("getNotesURL\tvon " + name(o) + ": " + o.getNotesURL());
		System.out.println ("getHttpURL\tvon " + name(o) + ": " + o.getHttpURL());
	}
	private static void printURLs (Form o) throws NotesException {
		System.out.println ("getURL\t\tvon " + name (o) + ": " + o.getURL());
		System.out.println ("getNotesURL\tvon " + name(o) + ": " + o.getNotesURL());
		System.out.println ("getHttpURL\tvon " + name(o) + ": " + o.getHttpURL());
	}
	private static void printURLs (View o) throws NotesException {
		System.out.println ("getURL\t\tvon " + name (o) + ": " + o.getURL());
		System.out.println ("getNotesURL\tvon " + name(o) + ": " + o.getNotesURL());
		System.out.println ("getHttpURL\tvon " + name(o) + ": " + o.getHttpURL());
	}
	private static void printURLs (Session o) throws NotesException {
		System.out.println ("getURL\t\tvon " + name (o) + ": " + o.getURL());
//		System.out.println ("getNotesURL\tvon " + name(o) + ": " + o.getNotesURL());
		System.out.println ("getHttpURL\tvon " + name(o) + ": " + o.getHttpURL());
	}

}
